<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('supplier_response_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('supplier_response_id')->constrained()->onDelete('cascade');
            $table->foreignId('purchase_request_item_id')->constrained()->onDelete('cascade');
            $table->boolean('is_accepted')->default(true);
            $table->decimal('supplied_quantity', 10, 4)->nullable();
            $table->decimal('price_per_unit', 15, 2)->nullable();
            $table->text('supplier_notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('supplier_response_items');
    }
};
