<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('purchase_requests', function (Blueprint $table) {
            // این ستون، شناسه پاسخ تایید شده نهایی را نگهداری می‌کند
            $table->foreignId('final_response_id')->nullable()->constrained('supplier_responses')->onDelete('set null')->after('approved_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('purchase_requests', function (Blueprint $table) {
            // First drop the foreign key constraint
            $table->dropForeign(['final_response_id']);
            // Then drop the column
            $table->dropColumn('final_response_id');
        });
    }
};

