<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('purchase_requests', function (Blueprint $table) {
            // First drop the foreign key constraint if it exists
            // The name is generated as table_column_foreign
            $table->dropForeign(['final_response_id']);
            $table->dropColumn('final_response_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('purchase_requests', function (Blueprint $table) {
            $table->foreignId('final_response_id')->nullable()->constrained('supplier_responses')->onDelete('set null')->after('approved_at');
        });
    }
};

