<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('purchase_request_items', function (Blueprint $table) {
            $table->string('status')->default('pending_offer')->after('unit');
            $table->foreignId('final_supplier_response_item_id')->nullable()->constrained('supplier_response_items')->onDelete('set null')->after('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('purchase_request_items', function (Blueprint $table) {
            $table->dropForeign(['final_supplier_response_item_id']);
            $table->dropColumn(['status', 'final_supplier_response_item_id']);
        });
    }
};

