<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('purchase_requests', function (Blueprint $table) {
            // این ستون، شناسه تأمین‌کننده‌ای را که درخواست به او محول شده، نگهداری می‌کند
            $table->foreignId('assigned_supplier_id')->nullable()->constrained('suppliers')->onDelete('set null')->after('project_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('purchase_requests', function (Blueprint $table) {
            $table->dropForeign(['assigned_supplier_id']);
            $table->dropColumn('assigned_supplier_id');
        });
    }
};
