<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            // Add the new research_team_id column
            $table->foreignId('research_team_id')->nullable()->after('id')->constrained()->onDelete('cascade');

            // Drop the old institution_id column
            $table->dropForeign(['institution_id']);
            $table->dropColumn('institution_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->dropForeign(['research_team_id']);
            $table->dropColumn('research_team_id');
            $table->foreignId('institution_id')->nullable()->after('id')->constrained()->onDelete('cascade');
        });
    }
};

