<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('inventory_items', function (Blueprint $table) {
            // Add the new research_team_id column
            $table->foreignId('research_team_id')->nullable()->after('id')->constrained()->onDelete('cascade');

            // Drop the old institution_id column
            if (Schema::hasColumn('inventory_items', 'institution_id')) {
                $table->dropForeign(['institution_id']);
                $table->dropColumn('institution_id');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('inventory_items', function (Blueprint $table) {
            if (Schema::hasColumn('inventory_items', 'research_team_id')) {
                $table->dropForeign(['research_team_id']);
                $table->dropColumn('research_team_id');
            }
            $table->foreignId('institution_id')->nullable()->after('id')->constrained()->onDelete('cascade');
        });
    }
};

