<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('institution_requests', function (Blueprint $table) {
            // این ستون، شناسه کاربری فرد رابط را نگهداری می‌کند
            $table->foreignId('contact_person_user_id')->nullable()->constrained('users')->onDelete('set null')->after('contact_person_name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('institution_requests', function (Blueprint $table) {
            $table->dropForeign(['contact_person_user_id']);
            $table->dropColumn('contact_person_user_id');
        });
    }
};

