<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        // طبق نقشه راه، جدول واسط برای ارتباط بین طرح و آیتم‌های انبار ایجاد می‌شود
        Schema::create('project_inventory_item', function (Blueprint $table) {
            $table->id();

            // کلید خارجی برای اتصال به جدول طرح‌ها (projects)
            // با onDelete('cascade')، اگر طرحی حذف شود، رکوردهای بودجه مربوط به آن نیز حذف می‌شوند
            $table->foreignId('project_id')->constrained()->onDelete('cascade');

            // کلید خارجی برای اتصال به جدول آیتم‌های انبار (inventory_items)
            // با onDelete('cascade')، اگر آیتمی از انبار حذف شود، رکوردهای بودجه آن نیز حذف می‌شوند
            $table->foreignId('inventory_item_id')->constrained()->onDelete('cascade');

            // حداکثر مقدار مجاز برای مصرف از این آیتم در این طرح خاص
            // از نوع decimal برای پشتیبانی از مقادیر اعشاری (مانند 10.5 میلی‌لیتر) استفاده می‌کنیم
            $table->decimal('max_allowed_quantity', 10, 2);

            // مقدار کل مصرف شده از این آیتم در این طرح تا به امروز
            // مقدار پیش‌فرض آن صفر است
            $table->decimal('total_consumed_quantity', 10, 2)->default(0);

            // ایجاد یک محدودیت منحصر به فرد ترکیبی
            // این کار از ثبت تکراری یک آیتم برای یک طرح جلوگیری می‌کند
            $table->unique(['project_id', 'inventory_item_id']);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('project_inventory_item');
    }
};
