<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // این جدول برای ذخیره دسترسی‌های سفارشی یک کاربر در یک طرح خاص استفاده می‌شود.
        Schema::create('project_user_permission', function (Blueprint $table) {
            $table->id();

            // کلید خارجی برای اتصال به جدول طرح‌ها (projects)
            $table->foreignId('project_id')->constrained()->onDelete('cascade');

            // کلید خارجی برای اتصال به جدول کاربران (users)
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // کلید خارجی برای اتصال به جدول دسترسی‌ها (permissions) پکیج Spatie
            $table->foreignId('permission_id')->constrained('permissions')->onDelete('cascade');

            $table->timestamps();

            // ایجاد یک کلید منحصر به فرد ترکیبی برای جلوگیری از ثبت تکراری یک دسترسی
            // برای یک کاربر در یک طرح.
            $table->unique(['project_id', 'user_id', 'permission_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_user_permission');
    }
};
