<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('inventory_consumption_requests', function (Blueprint $table) {
            $table->id();

            // کلید خارجی برای اتصال به طرح مربوطه
            $table->foreignId('project_id')->constrained()->onDelete('cascade');

            // کلید خارجی برای اتصال به یادداشت آزمایشگاه که این درخواست در آن ثبت شده
            $table->foreignId('lab_notebook_entry_id')->constrained()->onDelete('cascade');

            // کلید خارجی برای اتصال به کاربر درخواست دهنده
            $table->foreignId('requester_id')->constrained('users')->onDelete('cascade');

            // کلید خارجی برای اتصال به آیتم انبار مورد نظر
            $table->foreignId('inventory_item_id')->constrained()->onDelete('cascade');

            // نوع درخواست: مصرف از انبار یا بازگشت به انبار
            $table->enum('type', ['consumption', 'return']);

            // مقدار درخواست شده (با دقت بالا برای مقادیر اعشاری)
            $table->decimal('quantity', 10, 2);

            // وضعیت فعلی درخواست
            $table->enum('status', ['pending', 'approved', 'rejected'])->default('pending');

            // کلید خارجی برای اتصال به کاربری که درخواست را تایید یا رد کرده است (می‌تواند خالی باشد)
            $table->foreignId('approver_id')->nullable()->constrained('users')->onDelete('set null');

            // زمان پردازش درخواست (تایید یا رد)
            $table->timestamp('processed_at')->nullable();

            // یادداشت‌های اضافی (مثلاً دلیل رد درخواست)
            $table->text('notes')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inventory_consumption_requests');
    }
};
