<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            // این ستون، کاربری که مسئول گردش انبار این طرح است را مشخص می‌کند
            $table->foreignId('warehouse_manager_id')->nullable()->after('owner_id')->constrained('users')->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::table('projects', function (Blueprint $table) {
            $table->dropForeign(['warehouse_manager_id']);
            $table->dropColumn('warehouse_manager_id');
        });
    }
};

