<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tasks', function (Blueprint $table) {
            $table->id();

            // کلید خارجی برای اتصال به طرح مربوطه
            $table->foreignId('project_id')->constrained()->onDelete('cascade');

            // کلید خارجی برای اتصال به کاربری که این وظیفه را ایجاد کرده است
            $table->foreignId('creator_id')->constrained('users')->onDelete('cascade');

            $table->string('title');
            $table->text('description')->nullable();

            // وضعیت فعلی وظیفه
            $table->enum('status', ['برای انجام', 'در حال انجام', 'انجام شده'])->default('برای انجام');

            // اولویت وظیفه
            $table->enum('priority', ['پایین', 'متوسط', 'بالا'])->default('متوسط');

            $table->date('start_date')->nullable();
            $table->date('due_date')->nullable();
            $table->timestamp('completed_at')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tasks');
    }
};
