<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('task_user', function (Blueprint $table) {
            // این جدول واسط، رابطه چند به چند بین وظایف و کاربران را برقرار می‌کند

            // کلید خارجی برای اتصال به جدول وظایف (tasks)
            $table->foreignId('task_id')->constrained()->onDelete('cascade');

            // کلید خارجی برای اتصال به جدول کاربران (users)
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // تعریف کلید اصلی ترکیبی برای جلوگیری از تخصیص تکراری یک کاربر به یک وظیفه
            $table->primary(['task_id', 'user_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('task_user');
    }
};
