<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('task_comments', function (Blueprint $table) {
            $table->id();

            // کلید خارجی برای اتصال به وظیفه مربوطه
            $table->foreignId('task_id')->constrained()->onDelete('cascade');

            // کلید خارجی برای اتصال به کاربری که نظر را ثبت کرده است
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // متن اصلی نظر
            $table->text('body');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('task_comments');
    }
};
