<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('task_dependencies', function (Blueprint $table) {
            // این جدول، رابطه وابستگی بین دو وظیفه را مشخص می‌کند
            // (مثلاً وظیفه "ب" به وظیفه "الف" وابسته است)

            // کلید خارجی برای اتصال به وظیفه‌ای که پیش‌نیاز است
            $table->foreignId('task_id')->constrained('tasks')->onDelete('cascade');

            // کلید خارجی برای اتصال به وظیفه‌ای که وابسته است
            $table->foreignId('dependent_task_id')->constrained('tasks')->onDelete('cascade');

            // تعریف کلید اصلی ترکیبی برای جلوگیری از ثبت وابستگی تکراری
            $table->primary(['task_id', 'dependent_task_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('task_dependencies');
    }
};
