<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('time_logs', function (Blueprint $table) {
            $table->id();

            // کلید خارجی برای اتصال به وظیفه مربوطه
            $table->foreignId('task_id')->constrained()->onDelete('cascade');

            // کلید خارجی برای اتصال به کاربری که زمان را ثبت کرده است
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // زمان شروع کار روی وظیفه
            $table->timestamp('started_at');

            // زمان پایان کار روی وظیفه (می‌تواند خالی باشد اگر تایمر در حال اجرا باشد)
            $table->timestamp('ended_at')->nullable();

            // مدت زمان کل (به ثانیه) برای محاسبات ساده‌تر
            $table->unsignedInteger('duration_in_seconds')->nullable();

            // یادداشت‌های اضافی برای این لاگ زمانی
            $table->text('notes')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('time_logs');
    }
};
