<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lab_notebook_entry_task', function (Blueprint $table) {
            // این جدول واسط، رابطه چند به چند بین وظایف و یادداشت‌ها را برقرار می‌کند

            // کلید خارجی برای اتصال به جدول یادداشت‌ها
            $table->foreignId('lab_notebook_entry_id')->constrained()->onDelete('cascade');

            // کلید خارجی برای اتصال به جدول وظایف
            $table->foreignId('task_id')->constrained()->onDelete('cascade');

            // تعریف کلید اصلی ترکیبی برای جلوگیری از ثبت تکراری
            $table->primary(['lab_notebook_entry_id', 'task_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lab_notebook_entry_task');
    }
};
