<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('project_announcement_attachments', function (Blueprint $table) {
            $table->id();

            // کلید خارجی برای اتصال به اطلاعیه مربوطه
            $table->foreignId('project_announcement_id')->constrained()->onDelete('cascade');

            // کلید خارجی برای اتصال به کاربری که فایل را آپلود کرده است
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // مسیر ذخیره‌سازی فایل روی سرور
            $table->string('file_path');

            // نام اصلی فایل که توسط کاربر آپلود شده
            $table->string('file_name');

            // حجم فایل به بایت
            $table->unsignedBigInteger('file_size');

            // نوع MIME فایل (مثلاً: image/jpeg, application/pdf)
            $table->string('mime_type');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('project_announcement_attachments');
    }
};
