<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chat_messages', function (Blueprint $table) {
            $table->id();

            // کلید خارجی برای اتصال به اتاق گفتگوی مربوطه
            $table->foreignId('chat_room_id')->constrained()->onDelete('cascade');

            // کلید خارجی برای اتصال به کاربری که پیام را ارسال کرده است
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // متن اصلی پیام
            $table->text('body');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chat_messages');
    }
};
