<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chat_room_user', function (Blueprint $table) {
            // این جدول واسط، رابطه چند به چند بین اتاق‌های گفتگو و کاربران را برقرار می‌کند

            // کلید خارجی برای اتصال به جدول اتاق‌های گفتگو
            $table->foreignId('chat_room_id')->constrained()->onDelete('cascade');

            // کلید خارجی برای اتصال به جدول کاربران
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // تعریف کلید اصلی ترکیبی برای جلوگیری از تخصیص تکراری یک کاربر به یک اتاق
            $table->primary(['chat_room_id', 'user_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chat_room_user');
    }
};
