<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('chat_rooms', function (Blueprint $table) {
            // برای پشتیبانی از چت‌های شخصی، ما ابتدا محدودیت unique را از ستون project_id حذف کرده
            // و آن را به صورت nullable در می‌آوریم.
            $table->dropUnique(['project_id']);
            $table->foreignId('project_id')->nullable()->change();

            // ستون جدید برای تفکیک بین چت‌های گروهی و شخصی
            $table->enum('type', ['project', 'direct'])->default('project')->after('project_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('chat_rooms', function (Blueprint $table) {
            // بازگرداندن تغییرات به حالت اولیه
            $table->dropColumn('type');
            $table->foreignId('project_id')->nullable(false)->unique()->change();
        });
    }
};
