<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('chat_message_read_status', function (Blueprint $table) {
            // کلید خارجی برای اتصال به پیام مربوطه
            $table->foreignId('chat_message_id')->constrained()->onDelete('cascade');

            // کلید خارجی برای اتصال به کاربری که پیام را مشاهده کرده است
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // زمان مشاهده پیام
            $table->timestamp('read_at')->useCurrent();

            // تعریف کلید اصلی ترکیبی
            $table->primary(['chat_message_id', 'user_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('chat_message_read_status');
    }
};
