<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('equipment', function (Blueprint $table) {
            $table->id();

            // کلید خارجی برای اتصال به تیم تحقیقاتی مربوطه
            $table->foreignId('research_team_id')->constrained()->onDelete('cascade');

            $table->string('name');
            $table->string('model')->nullable();
            $table->string('serial_number')->nullable();

            // شناسه منحصر به فرد سیستمی
            $table->string('system_sku')->unique();

            // کد شناسایی که توسط کاربر وارد می‌شود
            $table->string('user_defined_id')->nullable();

            // کلید خارجی برای اتصال به کاربر مسئول تجهیز
            $table->foreignId('responsible_user_id')->nullable()->constrained('users')->onDelete('set null');

            // بازه زمانی کالیبراسیون به تعداد روز
            $table->unsignedInteger('calibration_interval_days')->nullable();

            $table->date('last_calibration_date')->nullable();
            $table->date('next_calibration_date')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('equipment');
    }
};
