<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('calibration_logs', function (Blueprint $table) {
            $table->id();

            // کلید خارجی برای اتصال به تجهیز مربوطه
            $table->foreignId('equipment_id')->constrained()->onDelete('cascade');

            // کلید خارجی برای اتصال به کاربری که کالیبراسیون را ثبت کرده است
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            // تاریخ انجام کالیبراسیون
            $table->date('calibration_date');

            // یادداشت‌های اضافی (مثلاً نتایج کالیبراسیون یا نام شرکت کالیبره کننده)
            $table->text('notes')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('calibration_logs');
    }
};
