<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('equipment', function (Blueprint $table) {
            // 1. ستون تیم تحقیقاتی را nullable می‌کنیم تا تجهیزات مستقل از تیم ثبت شوند
            $table->foreignId('research_team_id')->nullable()->change();

            // 2. ستون جدید برای ثبت مدیر مسئول تجهیز
            // [CORRECTED] حذف ->after('owner_id') برای جلوگیری از خطا
            $table->foreignId('manager_id')
                ->nullable()
                ->after('responsible_user_id') // برای نظم بیشتر، بعد از ستون کاربر مسئول قرار می‌گیرد
                ->constrained('users')
                ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('equipment', function (Blueprint $table) {
            // حذف ستون و کلید خارجی مدیر
            $table->dropForeign(['manager_id']);
            $table->dropColumn('manager_id');

            // بازگرداندن ستون تیم تحقیقاتی به حالت اولیه (غیر قابل تهی)
            $table->foreignId('research_team_id')->nullable(false)->change();
        });
    }
};
