<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // این ستون، ID کاربری را که به عنوان مسئول کالیبراسیون توسط این کاربر (مدیر تیم) انتخاب شده، ذخیره می‌کند
            $table->foreignId('calibration_manager_id')
                ->nullable()
                ->after('id') // برای نظم بیشتر، بعد از ستون id قرار می‌گیرد
                ->constrained('users')
                ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // حذف ستون و کلید خارجی
            $table->dropForeign(['calibration_manager_id']);
            $table->dropColumn('calibration_manager_id');
        });
    }
};
