<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // ابتدا کلید خارجی را حذف می‌کنیم
            $table->dropForeign(['calibration_manager_id']);
            // سپس خود ستون را حذف می‌کنیم
            $table->dropColumn('calibration_manager_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // در صورت نیاز به بازگرداندن تغییرات، ستون را دوباره اضافه می‌کنیم
            $table->foreignId('calibration_manager_id')
                ->nullable()
                ->after('id')
                ->constrained('users')
                ->onDelete('set null');
        });
    }
};
