<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // ما جدول موجود team_invitations را ویرایش می‌کنیم
        Schema::table('team_invitations', function (Blueprint $table) {
            // توکن منحصر به فرد و امن برای لینک دعوت
            $table->string('token', 64)->unique()->after('role');

            // تاریخ انقضای لینک دعوت
            $table->timestamp('expires_at')->after('token');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('team_invitations', function (Blueprint $table) {
            // در صورت نیاز به بازگرداندن تغییرات، ستون‌های جدید را حذف می‌کنیم
            $table->dropColumn(['token', 'expires_at']);
        });
    }
};
