<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('research_teams', function (Blueprint $table) {
            // ستون جدید برای ذخیره توضیحات تیم
            $table->text('description')->nullable()->after('name');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('research_teams', function (Blueprint $table) {
            // حذف ستون در صورت نیاز به بازگرداندن تغییرات
            $table->dropColumn('description');
        });
    }
};
