<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('team_announcements', function (Blueprint $table) {
            $table->id();

            // کلید خارجی برای اتصال به تیم تحقیقاتی مربوطه
            $table->foreignId('research_team_id')->constrained()->onDelete('cascade');

            // کلید خارجی برای اتصال به کاربری که اطلاعیه را ایجاد کرده است
            $table->foreignId('user_id')->constrained()->onDelete('cascade');

            $table->string('title');
            $table->text('body');

            // نوع اطلاعیه برای نمایش بصری متفاوت
            $table->enum('level', ['info', 'warning', 'danger'])->default('info');

            // برای پین کردن اطلاعیه‌های مهم در بالای لیست
            $table->boolean('is_pinned')->default(false);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('team_announcements');
    }
};
