<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('onboarding_checklist_items', function (Blueprint $table) {
            $table->id();

            // کلید خارجی برای اتصال هر آیتم چک‌لیست به یک تیم تحقیقاتی
            $table->foreignId('research_team_id')->constrained()->onDelete('cascade');

            // عنوان یا متن آیتم چک‌لیست (مثلاً: "مطالعه پروتکل ایمنی")
            $table->string('title');

            // برای مرتب‌سازی آیتم‌های چک‌لیست
            $table->unsignedInteger('order')->default(0);

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('onboarding_checklist_items');
    }
};
