<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tasks', function (Blueprint $table) {
            // ستون project_id را به صورت nullable تغییر می‌دهیم
            // نکته: برای اجرای این دستور، ممکن است نیاز به نصب پکیج `doctrine/dbal` داشته باشید
            // composer require doctrine/dbal
            $table->foreignId('project_id')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tasks', function (Blueprint $table) {
            // در صورت نیاز به بازگرداندن تغییرات، ستون را به حالت اولیه (غیر قابل تهی) بازمی‌گردانیم
            $table->foreignId('project_id')->nullable(false)->change();
        });
    }
};
