<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('research_team_user_permission', function (Blueprint $table) {
            // این جدول واسط، رابطه چند به چند بین تیم، کاربر و مجوز را برقرار می‌کند

            // کلید خارجی برای اتصال به تیم تحقیقاتی
            $table->foreignId('research_team_id')->constrained('research_teams')->onDelete('cascade');

            // کلید خارجی برای اتصال به کاربر
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');

            // کلید خارجی برای اتصال به مجوز (از جدول پکیج Spatie)
            $table->foreignId('permission_id')->constrained('permissions')->onDelete('cascade');

            // تعریف کلید اصلی ترکیبی برای جلوگیری از تخصیص تکراری یک مجوز به یک کاربر در یک تیم
            $table->primary(['research_team_id', 'user_id', 'permission_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('research_team_user_permission');
    }
};
