<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('attachments', function (Blueprint $table) {
            // افزودن ستون برای ثبت کاربری که فایل را آپلود کرده است
            $table->foreignId('user_id')
                ->nullable()
                ->after('lab_notebook_entry_id') // برای نظم بیشتر، بعد از شناسه یادداشت قرار می‌گیرد
                ->constrained('users')
                ->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('attachments', function (Blueprint $table) {
            // حذف ستون و کلید خارجی در صورت نیاز به بازگرداندن تغییرات
            $table->dropForeign(['user_id']);
            $table->dropColumn('user_id');
        });
    }
};
