<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('equipment', function (Blueprint $table) {
            $table->boolean('requires_temp_log')->default(false)->after('next_calibration_date');
            $table->decimal('min_temp', 5, 2)->nullable()->after('requires_temp_log');
            $table->decimal('max_temp', 5, 2)->nullable()->after('min_temp');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('equipment', function (Blueprint $table) {
            $table->dropColumn(['requires_temp_log', 'min_temp', 'max_temp']);
        });
    }
};
