<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('auditors', function (Blueprint $table) {
            $table->foreignId('research_team_id')
                ->after('id')
                ->constrained('research_teams')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('auditors', function (Blueprint $table) {
            $table->dropForeign(['research_team_id']);
            $table->dropColumn('research_team_id');
        });
    }
};
