<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->id();
            $table->uuid('uuid')->unique(); // For public reference
            $table->foreignId('user_id')->constrained('users'); // User who initiated payment
            $table->morphs('payable'); // Polymorphic relation (e.g., to a SupplierResponse)
            $table->unsignedBigInteger('amount'); // Amount in Toman/Rial
            $table->string('gateway_name');
            $table->string('transaction_id')->nullable(); // From the payment gateway
            $table->string('status')->default('pending'); // pending, successful, failed
            $table->timestamp('paid_at')->nullable();
            $table->json('meta')->nullable(); // To store extra data from gateway
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('payments');
    }
};
