<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('shipments', function (Blueprint $table) {
            // Adding new columns based on our plan
            $table->foreignId('purchase_request_id')
                ->after('supplier_id')
                ->constrained('purchase_requests')
                ->onDelete('cascade');

            $table->string('status')->default('shipped')->after('tracking_code');
            $table->text('notes')->nullable()->after('tracking_code');
            $table->timestamp('delivered_at')->nullable()->after('dispatched_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('shipments', function (Blueprint $table) {
            $table->dropForeign(['purchase_request_id']);
            $table->dropColumn([
                'purchase_request_id',
                'status',
                'notes',
                'delivered_at'
            ]);
        });
    }
};
