<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('research_teams', function (Blueprint $table) {
            $table->foreignId('purchasing_manager_id')->nullable()->after('calibration_manager_id')->constrained('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('research_teams', function (Blueprint $table) {
            $table->dropForeign(['purchasing_manager_id']);
            $table->dropColumn('purchasing_manager_id');
        });
    }
};
