<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('lab_notebook_comments', function (Blueprint $table) {
            $table->id();

            // Foreign key for the user who wrote the comment
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');

            // Foreign key for the lab notebook entry this comment belongs to
            $table->foreignId('lab_notebook_entry_id')->constrained('lab_notebook_entries')->onDelete('cascade');

            // For threaded replies: a comment can be a reply to another comment
            $table->foreignId('parent_id')->nullable()->constrained('lab_notebook_comments')->onDelete('cascade');

            // The body of the comment
            $table->text('body');

            // [Optional but Recommended] A unique identifier for the commented text block
            // This helps to anchor the comment to a specific part of the text.
            $table->string('comment_anchor_id')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('lab_notebook_comments');
    }
};
