<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('inventory_items', function (Blueprint $table) {
            // We add the new columns after the 'unit' column for better organization.

            // A decimal column for the price.
            $table->decimal('price', 10, 2)->nullable()->default(0)->after('unit');

            // A string column for the brand name.
            $table->string('brand')->nullable()->after('price');

            // A string column for the batch or lot number.
            $table->string('lot_number')->nullable()->after('brand');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('inventory_items', function (Blueprint $table) {
            // Drop the columns in the reverse order of their creation.
            $table->dropColumn(['price', 'brand', 'lot_number']);
        });
    }
};
