<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Add new columns to the inventory_items table for biological samples
        Schema::table('inventory_items', function (Blueprint $table) {
            $table->boolean('is_biological')->default(false)->after('item_type');
            $table->integer('passage_number')->nullable()->after('lot_number');
            $table->date('freeze_date')->nullable()->after('passage_number');
            $table->string('cell_type')->nullable()->after('freeze_date');
            $table->string('media_used')->nullable()->after('cell_type');
        });

        // Add a new column to the storage_locations table for tank structure type
        Schema::table('storage_locations', function (Blueprint $table) {
            $table->string('internal_structure_type')->nullable()->after('location_code');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('inventory_items', function (Blueprint $table) {
            $table->dropColumn(['is_biological', 'passage_number', 'freeze_date', 'cell_type', 'media_used']);
        });

        Schema::table('storage_locations', function (Blueprint $table) {
            $table->dropColumn('internal_structure_type');
        });
    }
};
