<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        // Get the database name to construct the key for the table list
        $dbName = DB::getDatabaseName();
        $key = "Tables_in_{$dbName}";

        // Get the tables as an array of objects
        $tablesAsObjects = DB::select('SHOW TABLES');

        // Extract the table names into a flat array using array_column (safer than reset)
        $tables = array_column($tablesAsObjects, $key);

        foreach ($tables as $table) {
            // We don't need to alter Laravel's default migration table
            if ($table !== 'migrations') {
                DB::statement("ALTER TABLE `{$table}` ENGINE = InnoDB");
            }
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        // Optional: Revert back to MyISAM
        $dbName = DB::getDatabaseName();
        $key = "Tables_in_{$dbName}";
        $tablesAsObjects = DB::select('SHOW TABLES');
        $tables = array_column($tablesAsObjects, $key);

        foreach ($tables as $table) {
            if ($table !== 'migrations') {
                DB::statement("ALTER TABLE `{$table}` ENGINE = MyISAM");
            }
        }
    }
};
