<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::table('storage_locations', function (Blueprint $table) {
            // Add a 'size' column to store the capacity of locations like canes.
            // Placed after 'columns' for logical grouping.
            $table->unsignedInteger('size')->nullable()->after('columns');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::table('storage_locations', function (Blueprint $table) {
            $table->dropColumn('size');
        });
    }
};
