<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('biological_sample_requests', function (Blueprint $table) {
            $table->id();

            // Foreign key to the specific sample being requested
            $table->foreignId('inventory_item_id')->constrained('inventory_items')->onDelete('cascade');

            // Foreign key to the research team this request belongs to
            $table->foreignId('research_team_id')->constrained('research_teams')->onDelete('cascade');

            // Foreign key to the user who is making the request
            $table->foreignId('requester_id')->constrained('users')->onDelete('cascade');

            // Foreign key to the authorized user who handles the checkout
            $table->foreignId('handler_id')->constrained('users')->onDelete('cascade');

            // The name of the person physically receiving the sample
            $table->string('recipient_name');

            // Timestamps for the checkout process
            $table->timestamp('checkout_date');
            $table->timestamp('expected_return_date');
            $table->timestamp('actual_return_date')->nullable();

            // Status of the request
            $table->string('status')->default('checked_out'); // e.g., checked_out, returned, overdue

            // Additional notes
            $table->text('notes')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('biological_sample_requests');
    }
};
