<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('research_teams', function (Blueprint $table) {
            $table->foreignId('warehouse_manager_id')->nullable()->constrained('users')->onDelete('set null')->after('purchasing_manager_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('research_teams', function (Blueprint $table) {
            $table->dropForeign(['warehouse_manager_id']);
            $table->dropColumn('warehouse_manager_id');
        });
    }
};
