<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Role; // مدل Role را فراخوانی می‌کنیم

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // ایجاد نقش‌های اصلی سیستم
        // ما از متد firstOrCreate استفاده می‌کنیم تا اگر نقشی از قبل وجود داشت، دوباره ایجاد نشود.
        Role::firstOrCreate(['name' => 'super_admin'], [
            'display_name' => 'مدیر کل سیستم',
            'scope' => 'system',
            'description' => 'دسترسی کامل به تمام بخش‌های سیستم'
        ]);

        Role::firstOrCreate(['name' => 'monitoring_user'], [
            'display_name' => 'کاربر مانیتورینگ مرکزی',
            'scope' => 'system',
            'description' => 'نظارت بر تمام نهادها و فعالیت‌های کلی سیستم'
        ]);

        Role::firstOrCreate(['name' => 'institution_admin'], [
            'display_name' => 'کاربر ارشد (رابط نهاد)',
            'scope' => 'institution',
            'description' => 'مدیریت کامل یک نهاد خاص'
        ]);

        Role::firstOrCreate(['name' => 'researcher'], [
            'display_name' => 'هیئت علمی/محقق',
            'scope' => 'institution',
            'description' => 'مدیریت طرح‌ها و پروژه‌های تحقیقاتی'
        ]);

        Role::firstOrCreate(['name' => 'student'], [
            'display_name' => 'کارشناس/دانشجو',
            'scope' => 'institution',
            'description' => 'اپراتور و مجری طرح‌های تحقیقاتی'
        ]);

        // نقش بازرگان در طرح شما ذکر شده بود، آن را هم اضافه می‌کنیم
        Role::firstOrCreate(['name' => 'merchant'], [
            'display_name' => 'بازرگان',
            'scope' => 'system', // یا 'institution' بسته به نیاز
            'description' => 'دسترسی به ماژول بازرگانی و مدیریت تامین‌کنندگان'
        ]);
    }
}
