<?php
namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\PermissionRegistrar;

class RolesAndPermissionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Reset cached roles and permissions
        app()[PermissionRegistrar::class]->forgetCachedPermissions();

        // تعریف دسترسی‌ها (Permissions)
        $permissions = [
            'project-view', 'project-edit', 'project-manage-collaborators', 'project-manage-budget',
            'labnotebook-view', 'labnotebook-create', 'labnotebook-edit', 'labnotebook-manage-materials', 'labnotebook-sign', 'labnotebook-lock',
            'system-view-dashboard', 'system-manage-users', 'system-manage-institutions', 'warehouse-manage-requests', 'view_project_menu', 'view_inventory_menu','view_myteamdashboard',
            'equipment-view-any', 'equipment-create', 'equipment-update', 'equipment-delete', 'team:edit-settings', 'team:invite-members',
            'team:manage-roles', 'purchase-request-approve', 'purchase-request-edit', 'purchase-request-reject','purchase-request-finalize-offers','manage_team_warehouse',
        ];

        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission, 'guard_name' => 'web']);
        }

        // تعریف نقش‌های مخصوص طرح
        $projectRoles = ['project_owner', 'main_collaborator', 'adviser', 'operator']; // Warehouse_Manager removed from here
        foreach ($projectRoles as $role) {
            Role::firstOrCreate(['name' => $role, 'guard_name' => 'web']);
        }

        // [REFACTORED] Centralized role definitions
        $systemRoles = [
            'purchasing_manager',
            'team_manager',
            'institute_manager',
            'team_member',
            'team_researcher',
            'Warehouse_Manager' // General role
        ];
        foreach ($systemRoles as $role) {
            Role::firstOrCreate(['name' => $role, 'guard_name' => 'web']);
        }


        // تخصیص دسترسی‌ها به نقش‌هایی که از قبل وجود دارند
        Role::findByName('super_admin')->givePermissionTo(Permission::all());
        Role::findByName('monitoring_user')->givePermissionTo(['system-view-dashboard']);
        Role::findByName('institution_admin')->givePermissionTo(['system-manage-users', 'system-manage-institutions', 'project-view', 'project-edit']);
        Role::findByName('researcher')->givePermissionTo(['project-view', 'project-edit', 'labnotebook-view', 'labnotebook-create', 'labnotebook-edit', 'labnotebook-manage-materials']);
        Role::findByName('student')->givePermissionTo(['project-view', 'labnotebook-view', 'labnotebook-create']);

        // تخصیص دسترسی به نقش‌های جدید طرح
        Role::findByName('project_owner')->givePermissionTo(Permission::all());
        Role::findByName('main_collaborator')->givePermissionTo(['project-view', 'labnotebook-view', 'labnotebook-create', 'labnotebook-edit', 'labnotebook-manage-materials']);
        Role::findByName('adviser')->givePermissionTo(['project-view', 'labnotebook-view']);
        Role::findByName('operator')->givePermissionTo(['project-view', 'labnotebook-view', 'labnotebook-create']);
        Role::findByName('Warehouse_Manager')->givePermissionTo(['warehouse-manage-requests', 'manage_team_warehouse']);

        Role::findByName('institute_manager')->givePermissionTo('view_project_menu', 'view_inventory_menu','view_myteamdashboard');
        Role::findByName('team_manager')->givePermissionTo('view_project_menu', 'view_inventory_menu','view_myteamdashboard', 'equipment-view-any', 'equipment-create', 'equipment-update', 'equipment-delete', 'team:edit-settings', 'team:invite-members',
            'team:manage-roles');

        // Assign permissions to the Purchasing Manager role
        Role::findByName('purchasing_manager')->givePermissionTo([
            'purchase-request-approve',
            'purchase-request-edit',
            'purchase-request-reject',
            'purchase-request-finalize-offers',
        ]);

        $this->command->info('Permissions have been assigned to existing roles.');
    }
}
