<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Project;
use Illuminate\Support\Facades\DB;

class TaskDependencySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // پیدا کردن اولین طرحی که حداقل دو وظیفه دارد
        $project = Project::has('tasks', '>=', 2)->first();

        if ($project) {
            $tasks = $project->tasks()->take(2)->get();
            $task1 = $tasks[0];
            $task2 = $tasks[1];

            // ایجاد یک وابستگی: وظیفه دوم به وظیفه اول وابسته است
            DB::table('task_dependencies')->insert([
                'task_id' => $task1->id,
                'dependent_task_id' => $task2->id,
            ]);

            $this->command->info('A sample task dependency has been created.');
        } else {
            $this->command->warn('Could not find a project with at least two tasks to create a dependency.');
        }
    }
}
